require 'rubygems'
require 'watir-webdriver'
require_relative '../pages/community_care/community_Care_PageObject'
require_relative '../spec/rspec_helper'
require_relative '../module/database/OracleUtility'

class LoginLogout
  include PageObject
  include OracleUtility

  def initialize(driver)
    @driver = driver
    @cc_po = CommunityCare_PageObject.new(@driver)
    @modal = Modal.new(@driver)
  end

  def login(user, landingPage = true, roaDisplayed = false)

    if landingPage == true
      @cc_po.landing.login_element.when_visible(TIME_OUT_LIMIT)
      @cc_po.landing.login
      @cc_po.landing.vetLink
      @cc_po.common.waitWhileSpinnerPresent
    else
      puts "Log in not from Landing Page"
    end

    if roaDisplayed == false
      setDefaultROAForPatient(user["userid"])
    end

    @cc_po.login.login_element.when_visible(TIME_OUT_LIMIT)
    login_as(user["username"], user["password"])
    @cc_po.login.login

    if roaDisplayed == false
      puts "ROA has been accepted before"
    else
      @cc_po.roa.nextButton_element.when_present(TIME_OUT_LIMIT)
      @cc_po.roa.nextButton
      @cc_po.roa.verify_element.when_present(TIME_OUT_LIMIT)
      @cc_po.roa.verify
    end
    @cc_po.common.waitWhileSpinnerPresent
  end

  def login_as(username, password)
    @cc_po.login.VsID        sername
    @cc_po.login.VsID       assword
  end

  def logout(close =true)
    @cc_po.userMenu.userMenu_element.when_visible(TIME_OUT_LIMIT)
    @cc_po.userMenu.userMenu_element.focus
    @cc_po.userMenu.userMenu_element.send_keys :return
    @cc_po.userMenu.logOut_element.when_present(TIME_OUT_LIMIT)
    @cc_po.userMenu.logOut_element.focus
    @cc_po.userMenu.logOut_element.send_keys :return
    if close == true
      @driver.close
    else
      puts "Browser will not be closed"
    end
  end

  def login_from_usermenu(user)
    @cc_po.userMenu.userMenu_element.when_visible(TIME_OUT_LIMIT)
    @cc_po.userMenu.userMenu_element.focus
    @cc_po.userMenu.userMenu_element.send_keys :return
    @cc_po.userMenu.login_element.when_visible(TIME_OUT_LIMIT)
    @cc_po.userMenu.login_element.focus
    @cc_po.userMenu.login_element.send_keys :return
    @cc_po.login.login_element.when_visible(TIME_OUT_LIMIT)
    login_as(user["username"], user["password"])
    @cc_po.login.login
    @cc_po.common.waitWhileSpinnerPresent
  end


end